varying vec2 texCoord;
vec2 iResolution=vec2(1920.0,1080.0);

uniform sampler2D bigMap;

uniform float testvalue;

vec2 fishEye(vec2 fragCoord )
{
	const float zoom = 1.28*0.86*1.24;
	vec2 p = (fragCoord.xy/vec2(1920.0,1080.0)-vec2(0.5,0.5))*zoom+vec2(0.5,0.5);// / iResolution.x;
	//const float p2 = 1920.0/1080.0;//iResolution.x / iResolution.y;
	//vec2 m = vec2(0.5, 0.5 / p2);
	vec2 m = vec2(0.5, 0.5);

  const float distortion = 2.0 * -4.0 * 0.8 * 0.2 * 1.45;
  float e = exp(distortion);
  const float radius = 1.0;
  float k0 = e / (e - 1.0) * radius;
  float k1 = distortion / radius;

  float dx = p.x - m.x;
  float dy = p.y - m.y;
  float distance = sqrt(dx * dx + dy * dy);

    // too far away ? don't apply anything
    if (distance >= radius)
      return p;

    float k = k0 * (1.0 - exp(-distance * k1)) / distance * 0.75 + 0.25;
    vec2 uv = vec2( m.x + dx * k, m.y + dy * k);

	return uv;
}

void main (void)
{
    vec3 pos;
    vec2 fragCoord=gl_FragCoord.xy;
    vec2 texCoord2=fishEye(fragCoord);
    vec4 col = texture2D(bigMap, texCoord2);

	gl_FragColor = col;
}
